
#ifndef CE2_ERROR_H
#define CE2_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object name     :  CE2_error.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:55:47 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This module defines the error return code types and the numbering spaces of the error codes
   *         for each module of the layers listed below.
   *
   *  \version CE2_error.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines ******************************/

/**
 * \brief The definitions of the error number space used for the different modules
 */

/* ........... Error base numeric mapping definitions ................... */
/* ----------------------------------------------------------------------- */
 
 /* The global error base number */
#define CE2_ERROR_BASE          0x00F00000UL

/* The error range number assigned for each layer */
#define CE2_ERROR_LAYER_RANGE   0x00010000UL

/* The error range number assigned to each module on its specified layer */
#define CE2_ERROR_MODULE_RANGE  0x00000100UL

/* Defines the layer index for the error mapping */
#define CE2_LAYER_ERROR_IDX       0UL
#define CE2_LLF_LAYER_ERROR_IDX   1UL

/* Defines the module index for error mapping */
#define CE2_AES_ERROR_IDX         0x0UL
#define CE2_DES_ERROR_IDX         0x1UL
#define CE2_HASH_ERROR_IDX        0x2UL
#define CE2_HMAC_ERROR_IDX        0x3UL
#define CE2_RSA_ERROR_IDX         0x4UL
#define CE2_DH_ERROR_IDX          0x5UL
#define CE2_RC4_ERROR_IDX         0x6UL
#define CE2_INTERNAL_ERROR_IDX    0x7UL
#define CE2_ECPKI_ERROR_IDX       0x8UL
#define CE2_CMLA_ERROR_IDX        0x9UL
#define CE2_CE2_SST_ERROR_IDX     0xAUL
#define CE2_PKI_ERROR_IDX         0xBUL
#define CE2_RND_ERROR_IDX         0xCUL
#define CE2_COMMON_ERROR_IDX      0xDUL
#define CE2_CCM_ERROR_IDX         0xEUL
#define CE2_INIT_ERROR_IDX        0xFUL
#define CE2_C2_ERROR_IDX          0x10UL
#define CE2_OTF_ERROR_IDX         0x11UL
#define CE2_KDF_ERROR_IDX         0x12UL
#define CE2_UTILS_ERROR_IDX       0x13UL
#define CE2_BASE64_ERROR_IDX      0x14UL
#define CE2_AESCCM_ERROR_IDX      0x15UL
#define CE2_LAST_ERROR_MODULE_IDX CE2_AESCCM_ERROR_IDX

/* .......... defining the error spaces for each module on each layer ........... */
/* ------------------------------------------------------------------------------ */

/* AES module on the CE2 layer base address - 0x00F00000 */
#define CE2_AES_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_AES_ERROR_IDX ) )  
                                    

/* AES module on the LLF layer base address -  0x00F10000 */
#define CE2_LLF_AES_MODULE_ERROR_BASE   (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_AES_ERROR_IDX ) )   

/* DES module on the CE2 layer base address - 0x00F00100 */
#define CE2_DES_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_DES_ERROR_IDX ) )   
                                    

/* DES module on the LLF layer base address -  0x00F10100 */
#define CE2_LLF_DES_MODULE_ERROR_BASE   (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_DES_ERROR_IDX ) )   

/* HASH module on the CE2 layer base address - 0x00F00200 */
#define CE2_HASH_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_HASH_ERROR_IDX ) )   
                                    
/* HASH module on the LLF layer base address -  0x00F10200 */
#define CE2_LLF_HASH_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_HASH_ERROR_IDX ) )   

/* HMAC module on the CE2 layer base address - 0x00F00300 */
#define CE2_HMAC_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_HMAC_ERROR_IDX ) )   

/* HMAC module on the LLF layer base address - 0x00F10300 */
#define CE2_LLF_HMAC_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_HMAC_ERROR_IDX ) )   

/* PKI RSA module on the CE2 layer base address - 0x00F00400 */
#define CE2_RSA_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_RSA_ERROR_IDX ) )   

/* PKI RSA module on the LLF layer base address - 0x00F10400 */
#define CE2_LLF_RSA_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_RSA_ERROR_IDX ) )

/* DH module on the CE2 layer base address - 0x00F00500 */
#define CE2_DH_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_DH_ERROR_IDX ) )   

/* DH module on the LLF layer base address -  0x00F10500 */
#define CE2_LLF_DH_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_DH_ERROR_IDX ) )

/* RC4 module on the CE2 layer base address - 0x00F00600 */
#define CE2_RC4_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_RC4_ERROR_IDX ) )   

/* INTERNAL debug error module on the CE2 layer base address - 0x00F00700 */
#define CE2_INTERNAL_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                        (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                        (CE2_ERROR_MODULE_RANGE * CE2_INTERNAL_ERROR_IDX ) )  
                                        
/* ECPKI module on the CE2 layer base address - 0x00F00800 */
#define CE2_ECPKI_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_ECPKI_ERROR_IDX ) ) 
                                     
/* ECPKI module on the LLF layer base address -  0x00F10800 */
#define CE2_LLF_ECPKI_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_ECPKI_ERROR_IDX ) )
                                     
/* CMLA module on the CE2 layer base address - 0x00F00900 */
#define CE2_CMLA_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_CMLA_ERROR_IDX ) )   

/* CMLA module on the LLF layer base address - 0x00F10900 */
#define CE2_LLF_CMLA_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_CMLA_ERROR_IDX ) )   
                                                                              
/* CRY_SST module on the CE2 layer base address - 0x00F00A00 */
#define CE2_SST_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_CE2_SST_ERROR_IDX ) )   
                                    

/* PKI RSA module on the LLF layer base address -  0x00F10B00 */
#define CE2_LLF_PKI_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * CE2_PKI_ERROR_IDX ) )   

/* RND module on the CE2 layer base address - 0x00F00C00 */
#define CE2_RND_MODULE_ERROR_BASE   (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_RND_ERROR_IDX ) )   
                                    
/* RND module on the LLF layer base address -  0x00F10C00 */
#define CE2_LLF_RND_MODULE_ERROR_BASE    (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_RND_ERROR_IDX ) )   

/* COMMMON module on the CE2 layer base address - 0x00F00D00 */
#define CE2_COMMON_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_COMMON_ERROR_IDX ) )                                          
                                      
/* COMMMON module on the LLF layer base address - 0x00F10D00 */
#define CE2_LLF_COMMON_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_COMMON_ERROR_IDX ) )                                          
                                      
/* CCM module on the CE2 layer base address - 0x00F00E00 */
#define CE2_CCM_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_CCM_ERROR_IDX ) )                                          

/* INIT module on the CE2 layer base address - 0x00F00F00 */
#define CE2_INIT_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_INIT_ERROR_IDX ) )                                          
                                     
/* C2 module on the CE2 layer base address - 0x00F01000 */
#define CE2_C2_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                 (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                 (CE2_ERROR_MODULE_RANGE * CE2_C2_ERROR_IDX ) )  

/* C2 module on the LLF layer base address -  0x00F11000 */
#define CE2_LLF_C2_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                 (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                 (CE2_ERROR_MODULE_RANGE * CE2_C2_ERROR_IDX ) )   

/* OTF module on the CE2 layer base address - 0x00F01100 */
#define CE2_OTF_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_OTF_ERROR_IDX ) )  

/* OTF module on the LLF layer base address -  0x00F11100 */
#define CE2_LLF_OTF_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_OTF_ERROR_IDX ) )   

/* KDF module on the CE2 layer base address - 0x00F01200 */
#define CE2_KDF_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_KDF_ERROR_IDX ) )  

/* KDF module on the LLF layer base address -  0x00F11200 */
#define CE2_LLF_KDF_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_KDF_ERROR_IDX ) )   

/* UTILS module on the CE2 layer base address - 0x00F01300 */
#define CE2_UTILS_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_UTILS_ERROR_IDX ) )  

/* UTILS module on the LLF layer base address -  0x00F11300 */
#define CE2_LLF_UTILS_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_UTILS_ERROR_IDX ) ) 

/* BASE64 module on the CE2 layer base address - 0x00F01400 */
#define CE2_BASE64_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_BASE64_ERROR_IDX))

/* BASE64 module on the LLF layer base address -  0x00F11400 */
#define CE2_LLF_BASE64_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                  (CE2_ERROR_LAYER_RANGE * CE2_LLF_LAYER_ERROR_IDX) + \
                                  (CE2_ERROR_MODULE_RANGE * CE2_BASE64_ERROR_IDX))

/* AESCCM module on the CE2 layer base address - 0x00F01500 */
#define CE2_AESCCM_MODULE_ERROR_BASE  (CE2_ERROR_BASE + \
                                     (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
                                     (CE2_ERROR_MODULE_RANGE * CE2_AESCCM_ERROR_IDX ) )  

/********************/
/* AES module error */
/********************/
/* DX_AES() error codes */
#define CE2_AES_DATA_IN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x01)
#define CE2_AES_DATA_OUT_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x02)
#define CE2_AES_DATA_IN_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x03)
#define CE2_AES_IV_COUNTER_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x04)
#define CE2_AES_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x05)
#define CE2_AES_KEY_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x06)
#define CE2_AES_OPERATION_MODE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x07)
#define CE2_AES_ENCRYPT_DECRYPT_FLAG_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x08)

/* CE2_AES_Wrap() error codes */
#define CE2_AES_WRAP_ILLEGAL_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x11)
#define CE2_AES_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x12)
#define CE2_AES_WRAP_KEY_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x13)                  
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x14)      
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_LEN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x15)  
#define CE2_AES_WRAP_ILLEGAL_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x16)
#define CE2_AES_WRAP_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x17)

/* CE2_AES_Unwrap() error codes */
#define CE2_AES_UNWRAP_ILLEGAL_WRAP_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x21)          
#define CE2_AES_UNWRAP_WRAP_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x22)          
#define CE2_AES_UNWRAP_KEY_LEN_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x23)                   
#define CE2_AES_UNWRAP_ILLEGAL_DATA_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x24)          
#define CE2_AES_UNWRAP_ILLEGAL_DATA_LEN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x25)      
#define CE2_AES_UNWRAP_ILLEGAL_DATA_LENGTH_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x26)       
#define CE2_AES_UNWRAP_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x27)

/* CE2_XTS_AES() error codes */
#define CE2_XTS_AES_ILLEGAL_TWEAK_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x31)
#define CE2_XTS_AES_ILLEGAL_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x32)
#define CE2_XTS_AES_ILLEGAL_KEY_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x33)
#define CE2_XTS_AES_ILLEGAL_ENCRYPT_MODE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x34)
#define CE2_XTS_AES_ILLEGAL_DATAIN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x35)
#define CE2_XTS_AES_TO_SHORT_DATA_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x36)
#define CE2_XTS_AES_ILLEGAL_DATAOUT_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x37)
#define CE2_XTS_AES_ILLEGAL_SECTOR_NUMBER_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x38)

/* CE2_AES_GCM() error codes */
#define CE2_AES_GCM_ILLEGAL_KEY_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x51)
#define CE2_AES_GCM_KEY_SIZE_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x52)
#define CE2_AES_GCM_ILLEGAL_IV_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x53)
#define CE2_AES_GCM_ILLEGAL_AAD_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x54)
#define CE2_AES_GCM_ENCRYPT_DECRYPT_FLAG_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x55)
#define CE2_AES_GCM_ILLEGAL_DATA_IN_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x56)
#define CE2_AES_GCM_ILLEGAL_DATA_OUT_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x58)
#define CE2_AES_GCM_ILLEGAL_TAG_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x58)
#define CE2_AES_GCM_ILLEGAL_TAG_SIZE_PTR_ERROR (CE2_AES_MODULE_ERROR_BASE + 0x59)

/********************/
/* AESCCM module error */
/********************/
/* CE2_AES_CCM() error codes */
#define CE2_AESCCM_ILLEGAL_KEY_SIZE_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x01UL)
#define CE2_AESCCM_INVALID_KEY_POINTER_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x02UL)
#define CE2_AESCCM_INVALID_ENCRYPT_MODE_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x03UL)
#define CE2_AESCCM_DATA_IN_POINTER_INVALID_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x05UL)
#define CE2_AESCCM_DATA_OUT_POINTER_INVALID_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x06UL)
#define CE2_AESCCM_DATA_IN_SIZE_ILLEGAL (CE2_AESCCM_MODULE_ERROR_BASE + 0x07UL)
#define CE2_AESCCM_DATA_OUT_DATA_IN_OVERLAP_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0BUL)
#define CE2_AESCCM_DATA_OUT_SIZE_INVALID_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x09UL)
#define CE2_AESCCM_ADDITIONAL_BLOCK_NOT_PERMITTED_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0AUL)
#define CE2_AESCCM_ILLEGAL_PARAMETER_SIZE_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0CUL)
#define CE2_AESCCM_ILLEGAL_PARAMETER_PTR_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0DUL)
#define CE2_AESCCM_ILLEGAL_DATA_TYPE_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0EUL)
#define CE2_AESCCM_CCM_MAC_INVALID_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x0FUL)
#define CE2_AESCCM_LAST_BLOCK_NOT_PERMITTED_ERROR (CE2_AESCCM_MODULE_ERROR_BASE + 0x10UL)

/********************/
/* C2 module error  */
/********************/
/* CE2_C2() error codes */
#define CE2_C2_CIPHER_INVALID_USER_CONTEXT_POINTER_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x01)       
#define CE2_C2_CIPHER_ILLEGAL_OPERATION_MODE_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x02)       
#define CE2_C2_CIPHER_INVALID_KEY_POINTER_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x03)       
#define CE2_C2_CIPHER_INVALID_ENCRYPT_MODE_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x04)       
#define CE2_C2_CIPHER_DATA_IN_POINTER_INVALID_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x05)       
#define CE2_C2_CIPHER_DATA_OUT_POINTER_INVALID_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x06)       
#define CE2_C2_CIPHER_DATA_SIZE_ILLEGAL (CE2_C2_MODULE_ERROR_BASE + 0x07)       
#define CE2_C2_CIPHER_DATA_OUT_DATA_IN_OVERLLAP_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x08)       

/* CE2_C2_HASH() error codes */
#define CE2_C2_HASH_DATA_IN_PTR_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x11)       
#define CE2_C2_HASH_RESULT_BUFFER_PTR_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x12)       

/* CE2_C2_OneWayFunc() error codes */
#define CE2_C2_ONEWAYFUNC_DATA1_PTR_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x21)       
#define CE2_C2_ONEWAYFUNC_DATA2_PTR_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x22)       
#define CE2_C2_ONEWAYFUNC_DATAOUT_PTR_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x23)       

/* LLF_C2_LoadSecretConstant() error codes */
#define CE2_LLF_C2_LOAD_SECTET_CONSTANT_CANT_OPEN_FILE (CE2_LLF_C2_MODULE_ERROR_BASE + 0x01) 
#define CE2_LLF_C2_LOAD_SECTET_CONSTANT_CANT_READ_FILE (CE2_LLF_C2_MODULE_ERROR_BASE + 0x02) 

/********************/
/* DES module error */
/********************/
/* CE2_DES() error codes */
#define CE2_DES_INVALID_KEY_PTR_ERROR		(CE2_DES_MODULE_ERROR_BASE + 0x01)
#define CE2_DES_ILLEGAL_ENCRYPT_DECRYPT_FLAG_ERROR	(CE2_DES_MODULE_ERROR_BASE + 0x02)
#define CE2_DES_ILLEGAL_NUM_OF_KEYS_ERROR	(CE2_DES_MODULE_ERROR_BASE + 0x03)
#define CE2_DES_ILLEGAL_HASH_OP_MODE_ERROR	(CE2_DES_MODULE_ERROR_BASE + 0x04)
#define CE2_DES_INVALID_DATA_IN_PTR_ERROR	(CE2_DES_MODULE_ERROR_BASE + 0x05)
#define CE2_DES_INVALID_DATA_IN_SIZE_ERROR	(CE2_DES_MODULE_ERROR_BASE + 0x06)

/********************/
/* DH module error  */
/********************/
/* _DX_DH_GeneratePubPrv() error codes */
#define CE2_DH_GENERATE_PUB_PRV_GENARATOR_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x01)
#define CE2_DH_GENERATE_PUB_PRV_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x02)
#define CE2_DH_GENERATE_PUB_PRV_Q_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x03)
#define CE2_DH_GENERATE_PUB_PRV_ILLEGAL_DH_MODE (CE2_DH_MODULE_ERROR_BASE + 0x04)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PRIVATE_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x07)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PRIVATE_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x08)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x09)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PUBLIC_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x0A)

/* _DX_DH_KeyDerivationFunc() error codes */
#define CE2_DH_KEY_DER_FUNC_ZZ_SECRET_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x11)
#define CE2_DH_KEY_DER_FUNC_KEYING_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x12)
#define CE2_DH_KEY_DER_FUNC_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x13)

/* _DX_DH_X942_GetSecretData error codes */
#define CE2_DH_X942_GET_SECRET_DATA_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x23)
#define CE2_DH_X942_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x24)
#define CE2_DH_X942_GET_SECRET_DATA_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x26)
#define CE2_DH_X942_GET_SECRET_DATA_ILLEGAL_DER_FUNC_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x27)
#define CE2_DH_X942_GET_SECRET_DATA_SECRET_KEY_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x28)

/* _DX_DH_X942_Hybrid_GetSecretData error codes */
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x33)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR1_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x34)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR2_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x35)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SERVER_PUBLIC_KEY_PTR1_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x36)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SERVER_PUBLIC_KEY_PTR2_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x37)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x38)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_ILLEGAL_DER_FUNC_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x39)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SECRET_KEY_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x3A)

/* CE2_DH_PKCS3_GetSecretKey error codes */
#define CE2_DH_PKCS3_GET_SECRET_KEY_CLIENT_PRV_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x41)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SERVER_PUB_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x42)
#define CE2_DH_PKCS3_GET_SECRET_KEY_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x43)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SECRET_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x46)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SECRET_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x47)

/* CE2_DH_CheckPubKey error codes */
#define CE2_DH_INVALID_ARGUMENT_POINTER_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x0UL)
#define CE2_DH_INVALID_MODULUS_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x20UL)
#define CE2_DH_INVALID_ORDER_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x21UL)
#define CE2_DH_INVALID_PUBLIC_KEY_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x27UL)
#define CE2_DH_INVALID_PUBLIC_KEY_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x2DUL)

/* CE2_DH_CheckDomainParams error codes */
#define CE2_DH_CHECK_SEED_SIZE_OR_PTR_NOT_VALID_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x2AUL)
#define CE2_DH_CHECK_GENERATOR_SIZE_OR_PTR_NOT_VALID_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x29UL)
#define CE2_DH_CHECK_DOMAIN_PRIMES_NOT_VALID_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x25UL)
#define CE2_DH_CHECK_GENERATOR_NOT_VALID_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x2BUL)

/* CE2_DH_CreateDomainParams error codes */
#define CE2_DH_INVALID_SEED_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x22UL)
#define CE2_DH_INVALID_GENERATOR_PTR_OR_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x24UL)
#define CE2_DH_INVALID_J_FACTOR_PTR_OR_SIZE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x23UL)

/**********************/
/* ECPKI module error */
/**********************/
/* CE2_ECPKI_GenKeyPair() error codes */
#define CE2_ECPKI_GEN_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x01)
#define CE2_ECPKI_GEN_KEY_INVALID_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x02)
#define CE2_ECPKI_GEN_KEY_INVALID_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x03)

/* CE2_ECPKI_BuildPrivKey() error codes */
#define CE2_ECPKI_BLD_PRIV_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x11)
#define CE2_ECPKI_BLD_PRIV_KEY_INVALID_PRIVATE_KEY_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x12)
#define CE2_ECPKI_BLD_PRIV_KEY_INVALID_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x13)
/* LLF_ECPKI_BuildPrivKey() error codes */
#define LLF_ECPKI_BLD_PRIV_KEY_INVALID_PRIVATE_KEY_SIZE_ERROR (CE2_LLF_ECPKI_MODULE_ERROR_BASE + 0x11)

/* CE2_ECPKI_BuildPublKey() error codes */
#define CE2_ECPKI_BLD_PUBL_KEY_ILLEGAL_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x21)
#define CE2_ECPKI_BLD_PUBL_KEY_INVALID_PUBLIC_KEY_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x22)
#define CE2_ECPKI_BLD_PUBL_KEY_INVALID_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x23)
/* LLF_ECPKI_BuildPublKey() error codes */
#define LLF_ECPKI_BLD_PUBL_KEY_INVALID_PUBLIC_KEY_SIZE_ERROR (CE2_LLF_ECPKI_MODULE_ERROR_BASE + 0x21)

/* CE2_ECPKI_SVDP_DH() error codes */
#define CE2_ECPKI_SVDP_DH_INVALID_BUILDED_PARTNER_PUBLIC_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x31)
#define CE2_ECPKI_SVDP_DH_INVALID_USER_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x32)
#define CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x33)
#define CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x34)
#define CE2_ECPKI_SVDP_DH_INVALID_DOMAIN_ID_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x35)
/* LLF_ECPKI_SVDP_DH() error codes */
#define LLF_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_ERROR (CE2_LLF_ECPKI_MODULE_ERROR_BASE + 0x31)

/* CE2_ECDSA_Sign() error codes */
#define CE2_ECDSA_SIGN_INVALID_USER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x41)
#define CE2_ECDSA_SIGN_ILLEGAL_HASH_OP_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x42)
#define CE2_ECDSA_SIGN_INVALID_MESSAGE_DATA_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x43)
#define CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x44)
#define CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x45)
#define CE2_ECDSA_SIGN_INVALID_EPHEMERAL_KEY_IN_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x46)

/* CE2_ECDSA_Verify() error codes */
#define CE2_ECDSA_VERIFY_INVALID_SIGNER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x51)
#define CE2_ECDSA_VERIFY_ILLEGAL_HASH_OP_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x52)
#define CE2_ECDSA_VERIFY_INVALID_SIGNATURE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x53)
#define CE2_ECDSA_VERIFY_INVALID_MESSAGE_DATA_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x54)

/* _DX_ECPKI_ELGAMAL_Encrypt() error codes */
#define CE2_EC_ELGAMAL_ENCR_INVALID_RECEIVER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x61)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x62)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x63)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x64)
#define CE2_EC_ELGAMAL_ENCR_INVALID_EPHEMERAL_KEY_IN_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x65)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x66)
#define CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x67)

/* CE2_ECPKI_ELGAMAL_Decrypt */
#define CE2_EC_ELGAMAL_DECR_INVALID_RECEIVER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x71)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x72)
#define CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x73)
#define CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x74)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x75)
#define CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_OUT_SIZE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x76)

/* CE2_ECPKI_ExportPublKey error codes */
#define CE2_ECPKI_EXPORT_PUBL_KEY_INVALID_USER_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x81)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_COMPRESSION_MODE_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x82)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_PUBL_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x83)
#define CE2_ECPKI_EXPORT_PUBL_KEY_ILLEGAL_PUBL_KEY_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x84)
/* LLF_ECPKI_ExportPublKey error codes */
#define LLF_ECPKI_EXPORT_PUBL_KEY_INVALID_PUBL_KEY_SIZE_ERROR (CE2_LLF_ECPKI_MODULE_ERROR_BASE + 0x81)

/* CE2_ECPKI_ExportPrivKey error codes */
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_USER_PRIV_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x91)
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x92)
#define CE2_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_SIZE_PTR_ERROR (CE2_ECPKI_MODULE_ERROR_BASE + 0x93)
/* LLF_ECPKI_ExportPrivKey error codes */
#define LLF_ECPKI_EXPORT_PRIVATE_KEY_INVALID_EXTERN_PRIVATE_KEY_SIZE_ERROR (CE2_LLF_ECPKI_MODULE_ERROR_BASE + 0x91)

/**********************/
/* HASH module error  */
/**********************/
/* CE2_HASH() error codes */
#define CE2_HASH_INVALID_USER_CONTEXT_POINTER_ERROR (CE2_HASH_MODULE_ERROR_BASE + 0x0UL)
#define CE2_HASH_ILLEGAL_HASH_OP_MODE_ERROR (CE2_HASH_MODULE_ERROR_BASE + 0x01)
#define CE2_HASH_INVALID_DATA_IN_PTR_ERROR  (CE2_HASH_MODULE_ERROR_BASE + 0x02)
#define CE2_HASH_INVALID_HASH_RESULT_BUFF_PTR_ERROR	(CE2_HASH_MODULE_ERROR_BASE + 0x03)

/**********************/
/* HMAC module error  */
/**********************/
/* CE2_HMAC() error codes */
#define CE2_HMAC_ILLEGAL_HASH_OP_MODE_ERROR (CE2_HMAC_MODULE_ERROR_BASE + 0x01)
#define CE2_HMAC_INVALID_KEY_PTR_ERROR		  (CE2_HMAC_MODULE_ERROR_BASE + 0x02)
#define CE2_HMAC_INVALID_DATA_IN_PTR_ERROR  (CE2_HMAC_MODULE_ERROR_BASE + 0x03)
#define CE2_HMAC_INVALID_HASH_RESULT_BUFF_PTR_ERROR	(CE2_HMAC_MODULE_ERROR_BASE + 0x04)

/*********************/
/* RC4 module error  */
/*********************/
/* CE2_RC4() error codes */
#define CE2_RC4_KEY_PTR_ERROR      (CE2_RC4_MODULE_ERROR_BASE + 0x01)
#define CE2_RC4_DATA_IN_PTR_ERROR  (CE2_RC4_MODULE_ERROR_BASE + 0x02) 
#define CE2_RC4_DATA_OUT_PTR_ERROR (CE2_RC4_MODULE_ERROR_BASE + 0x03) 

/*********************/
/* RSA module error  */
/*********************/
/* CE2_RSA_Build_PubKey() error code */
#define CE2_RSA_BUILD_PUBKEY_INVALID_PUB_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x01)
#define CE2_RSA_BUILD_PUBKEY_INVALID_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x02)
#define CE2_RSA_BUILD_PUBKEY_INVALID_MODULUS_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x03)
#define CE2_RSA_BUILD_PUBKEY_INVALID_MODULUS_MS_BIT_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x04)
#define CE2_RSA_BUILD_PUBKEY_INVALID_MODULUS_SIZE (CE2_RSA_MODULE_ERROR_BASE + 0x05)

/* CE2_RSA_Build_PrivKey() error code */
#define CE2_RSA_BUILD_PRIVKEY_INVALID_PRIV_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x11)
#define CE2_RSA_BUILD_PRIVKEY_INVALID_PRIV_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x12)
#define CE2_RSA_BUILD_PRIVKEY_INVALID_PUB_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x13)
#define CE2_RSA_BUILD_PRIVKEY_INVALID_MODULUS_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x14)
#define CE2_RSA_BUILD_PRIVKEY_INVALID_MODULUS_MS_BIT_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x15)
#define CE2_RSA_BUILD_PRIVKEY_INVALID_MODULUS_SIZE (CE2_RSA_MODULE_ERROR_BASE + 0x16)

/* CE2_RSA_Build_PrivKeyCRT() error code */
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_PRIV_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x21)
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_P_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x22)
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_Q_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x23)
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_DP_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x24)
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_DQ_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x25)
#define CE2_RSA_BUILD_PRIVKEYCRT_INVALID_QINV_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x26)

/* CE2_RSA_Get_PubKey() error code */
#define CE2_RSA_GET_PUBKEY_INVALID_PUB_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x41)
#define CE2_RSA_GET_PUBKEY_INVALID_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x42)
#define CE2_RSA_GET_PUBKEY_INVALID_MODULUS_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x43)

/* CE2_RSA_Get_ModSizeFromPubKey() error code */
#define CE2_RSA_GET_MODSIZEFROMPUBKEY_INVALID_PUB_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x51)
#define CE2_RSA_GET_MODSIZEFROMPUBKEY_INVALID_MODULUS_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x51)

/* CE2_RSA_Get_PrivKey() error code */
#define CE2_RSA_GET_PRIVKEY_INVALID_PRIV_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x61)
#define CE2_RSA_GET_PRIVKEY_INVALID_PRIV_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x62)
#define CE2_RSA_GET_PRIVKEY_INVALID_PRIV_EXPONENT_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x63)
#define CE2_RSA_GET_PRIVKEY_INVALID_PUB_EXPONENT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x64)
#define CE2_RSA_GET_PRIVKEY_INVALID_PUB_EXPONENT_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x65)
#define CE2_RSA_GET_PRIVKEY_INVALID_MODULUS_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x66)
#define CE2_RSA_GET_PRIVKEY_INVALID_MODULUS_PTR_SIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x67)

/* CE2_RSA_Get_PrivKeyCRT() error code */
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_PRIV_KEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x71)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_P_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x72)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_P_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x73)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_Q_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x74)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_Q_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x75)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_DP_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x76)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_DP_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x77)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_DQ_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x78)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_DQ_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x79)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_QINV_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x7A)
#define CE2_RSA_GET_PRIVKEYCRT_INVALID_QINV_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x7B)
#define CE2_RSA_GET_PRIVKEYCRT_IS_NOT_CRT_KEY_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x7C)

/* CE2_RSA_KG_GenerateKeyPair() error code */
#define CE2_RSA_KG_GENKEYPAIR_INVALID_PUBEXP_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x81)
#define CE2_RSA_KG_GENKEYPAIR_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x82)
#define CE2_RSA_KG_GENKEYPAIR_INVALID_PRIVKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x83)
#define CE2_RSA_KG_GENKEYPAIR_INVALID_MODULUS_SIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x84)
#define CE2_RSA_KG_GENKEYPAIR_INVALID_EXPONENT_SIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x85)

/* CE2_RSA_KG_GenerateKeyPairCRT() error code */
#define CE2_RSA_KG_GENKEYPAIRCRT_INVALID_PUBEXP_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x91)
#define CE2_RSA_KG_GENKEYPAIRCRT_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x92)
#define CE2_RSA_KG_GENKEYPAIRCRT_INVALID_PRIVKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x93)
#define CE2_RSA_KG_GENKEYPAIRCRT_INVALID_MODULUS_SIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x94)
#define CE2_RSA_KG_GENKEYPAIRCRT_INVALID_EXPONENT_SIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0x95)

/* CE2_RSA_PRIM_Encrypt() error code */
#define CE2_RSA_PRIM_ENCRYPT_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xA1)
#define CE2_RSA_PRIM_ENCRYPT_INVALID_DATA_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xA2)
#define CE2_RSA_PRIM_ENCRYPT_INVALID_OUTPUT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xA3)

/* CE2_RSA_PRIM_Decrypt() error code */
#define CE2_RSA_PRIM_DECRYPT_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xB1)
#define CE2_RSA_PRIM_DECRYPT_INVALID_DATA_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xB2)
#define CE2_RSA_PRIM_DECRYPT_INVALID_OUTPUT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xB3)

/* _DX_RSA_SCHEMES_Encrypt() error code */
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC1)
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_HASHMODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC2)
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_MGF_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC3)
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_PKCS_VERSION_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC4)
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_DATAIN_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC5)
#define CE2_RSA_SCHEMES_ENCRYPT_INVALID_DATAOUT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xC6)

/* _DX_RSA_SCHEMES_Decrypt() error code */
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_DATA_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD1)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_DATASIZE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD2)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_OUTPUT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD3)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_OUTPUT_SIZE_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD4)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_HASH_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD5)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_MGF_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD6)
#define CE2_RSA_SCHEMES_DECRYPT_INVALID_PKCS_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xD7)

/* _DX_RSA_Sign() error code */
#define CE2_RSA_SCHEMES_SIGN_INVALID_PRIVKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE1)
#define CE2_RSA_SCHEMES_SIGN_PRIVKEY_VALIDATION_TAG_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE2)
#define CE2_RSA_SCHEMES_SIGN_ILLEGAL_HASH_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE3)
#define CE2_RSA_SCHEMES_SIGN_ILLEGAL_MGF_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE4)
#define CE2_RSA_SCHEMES_SIGN_ILLEGAL_PKCS_VERSION_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE5)
#define CE2_RSA_SCHEMES_SIGN_INVALID_DATA_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE6)
#define CE2_RSA_SCHEMES_SIGN_INVALID_OUTPUT_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xE7)

/* _DX_RSA_Verify() error code */
#define CE2_RSA_SCHEMES_VERIFY_INVALID_PUBKEY_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF1)
#define CE2_RSA_SCHEMES_VERIFY_PUBKEY_VALIDATION_TAG_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF2)
#define CE2_RSA_SCHEMES_VERIFY_ILLEGAL_HASH_MODE_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF3)
#define CE2_RSA_SCHEMES_VERIFY_ILLEGAL_MGF_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF4)
#define CE2_RSA_SCHEMES_VERIFY_ILLEGAL_PKCS_VERSION_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF5)
#define CE2_RSA_SCHEMES_VERIFY_INVALID_DATAIN_PTR_ERROR (CE2_RSA_MODULE_ERROR_BASE + 0xF6)

/*********************/
/* OTF module error  */
/*********************/
/* DX_AES2AES2HASH_OTF error code */
#define CE2_OTF_AES2AES2HASH_INVALID_DATAIN_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x01)
#define CE2_OTF_AES2AES2HASH_INVALID_DATAOUT_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x02)
#define CE2_OTF_AES2AES2HASH_ILLEGAL_HASH_CHAIN_MODE_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x03)

/* DX_AES2DES2HASH_OTF error code */
#define CE2_OTF_AES2DES2HASH_INVALID_DATAIN_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x11)
#define CE2_OTF_AES2DES2HASH_INVALID_DATAOUT_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x12)
#define CE2_OTF_AES2DES2HASH_ILLEGAL_HASH_CHAIN_MODE_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x13)

/* DX_DES2AES2HASH_OTF error code */
#define CE2_OTF_DES2AES2HASH_INVALID_DATAIN_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x21)
#define CE2_OTF_DES2AES2HASH_INVALID_DATAOUT_PTR_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x22)
#define CE2_OTF_DES2AES2HASH_ILLEGAL_HASH_CHAIN_MODE_ERROR (CE2_OTF_MODULE_ERROR_BASE + 0x23)

/*********************/
/* KDF module error  */
/*********************/
/* _DX_KDF_KeyDerivFunc error code */
#define CE2_KDF_KEY_DERIV_FUNC_ZZSECRET_PTR_ERROR (CE2_KDF_MODULE_ERROR_BASE + 0x01)
#define CE2_KDF_KEY_DERIV_FUNC_OTHERINFO_PTR_ERROR (CE2_KDF_MODULE_ERROR_BASE + 0x02)
#define CE2_KDF_KEY_DERIV_FUNC_KEYINGDATA_PTR_ERROR (CE2_KDF_MODULE_ERROR_BASE + 0x03)
#define CE2_KDF_KEY_DERIV_FUNC_KDF_HASH_MODE_ERROR (CE2_KDF_MODULE_ERROR_BASE + 0x04)
#define CE2_KDF_KEY_DERIV_FUNC_DERIVATION_MODE_ERROR (CE2_KDF_MODULE_ERROR_BASE + 0x05)

/*********************/
/* RND module error  */
/*********************/
#define CE2_RND_DATA_OUT_POINTER_INVALID_ERROR   (CE2_RND_MODULE_ERROR_BASE + 0x00)
#define CE2_RND_CAN_NOT_GENERATE_RAND_IN_RANGE   (CE2_RND_MODULE_ERROR_BASE + 0x01)
#define CE2_RND_CPRNG_TEST_FAIL_ERROR            (CE2_RND_MODULE_ERROR_BASE + 0x02)
#define CE2_RND_ADDITIONAL_INPUT_BUFFER_NULL     (CE2_RND_MODULE_ERROR_BASE + 0x03)
#define CE2_RND_ADDITIONAL_INPUT_SIZE_ERROR      (CE2_RND_MODULE_ERROR_BASE + 0x04)
#define CE2_RND_IS_NOT_SUPPORTED                 (CE2_RND_MODULE_ERROR_BASE + 0x0F)
/* CE2_RND_GenerateVector error code */
#define CE2_RND_GENERATE_VECTOR_OUTPUT_PTR_ERROR (CE2_RND_MODULE_ERROR_BASE + 0x01)

/* CE2_RND_GenerateVectorInRange error code */
#define CE2_RND_GENERATE_VECTOR_IN_RANGE_MAXVECT_PTR_ERROR (CE2_RND_MODULE_ERROR_BASE + 0x11)
#define CE2_RND_GENERATE_VECTOR_IN_RANGE_RNDVECT_PTR_ERROR (CE2_RND_MODULE_ERROR_BASE + 0x12)

/**********************/
/* CMLA module error  */
/**********************/
/* CE2_CMLA_KDF error code */
#define CE2_CMLA_KDF_INVALID_SEED_POINTER_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x01)
#define CE2_CMLA_KDF_INVALID_KEK_POINTER_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x02)

/* CE2_CMLA_Wrap error code */
#define CE2_CMLA_WRAP_ILLEGAL_KEK_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x11)
#define CE2_CMLA_WRAP_ILLEGAL_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x12)
#define CE2_CMLA_WRAP_ILLEGAL_WRAPPED_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x13)

/* CE2_CMLA_Unwrap error code */
#define CE2_CMLA_UNWRAP_ILLEGAL_KEK_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x21)
#define CE2_CMLA_UNWRAP_ILLEGAL_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x22)
#define CE2_CMLA_UNWRAP_ILLEGAL_WRAPPED_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x23)

/* CE2_CMLA_RSA_Encrypt error code */
#define CE2_CMLA_RSA_ENCRYPT_ILLEGAL_PUB_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x31)
#define CE2_CMLA_RSA_ENCRYPT_ILLEGAL_MESSAGE_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x32)
#define CE2_CMLA_RSA_ENCRYPT_ILLEGAL_ENCR_MESSAGE_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x33)
#define CE2_CMLA_RSA_ENCRYPT_MESSAGE_INTEGER_TOO_LONG_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x35)

/* CE2_CMLA_RSA_Decrypt error code */
#define CE2_CMLA_RSA_DECRYPT_ILLEGAL_PRIV_KEY_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x41)
#define CE2_CMLA_RSA_DECRYPT_ILLEGAL_MESSAGE_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x42)
#define CE2_CMLA_RSA_DECRYPT_ILLEGAL_ENCR_MESSAGE_PTR_ERROR (CE2_CMLA_MODULE_ERROR_BASE + 0x43)

/**********************/
/* Utils module error */
/**********************/
#define CE2_UTILS_INVALID_POINTER_ERROR (CE2_UTILS_MODULE_ERROR_BASE + 0x01)

/**********************/
/* Base64 module error */
/**********************/
#define CE2_BASE64_INPUT_BUFFER_INVALID_PTR_ERROR       (CE2_BASE64_MODULE_ERROR_BASE + 0x01)
#define CE2_BASE64_OUTPUT_BUFFER_INVALID_PTR_ERROR      (CE2_BASE64_MODULE_ERROR_BASE + 0x02)
#define CE2_BASE64_OUTPUT_BUFFER_SIZE_INVALID_PTR_ERROR (CE2_BASE64_MODULE_ERROR_BASE + 0x03)
#define CE2_BASE64_OUTPUT_BUFFER_SIZE_TOO_SMALL_ERROR   (CE2_BASE64_MODULE_ERROR_BASE + 0x04)

/* ............ The OK (success) definition ....................... */
#define CE2_OK 0                         
                                                                                                            
/************************ Enums ********************************/


/************************ Typedefs  ****************************/

/**
 * \brief The typedef definition of all of the error codes that are returned from the CE2 functions 
 */
 
typedef DxUint32_t CE2Error_t;

/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

/**
****************************************************************
* Function Name: 
* CE2_GetErrorDescription
*
*  @param error [in] - error code that is used to retrieve error
*                      description.
*
* @returns \b
*  DxUint8_t* - pointer to the specified error description string.
*
* \brief \b 
* Description:
*  This function returns error description using error code.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_GetErrorDescription 
*     to get error string by error code.
***************************************************************/
CE2CIMPORT_C DxUint8_t* CE2_GetErrorDescription(CE2Error_t error/* in */);

#ifdef __cplusplus
}
#endif

#endif




